import { c as create_ssr_component, e as escape, b as add_attribute, f as each, v as validate_component } from './ssr-73f02b7a.js';
import { f as formatDate, B as BlogContentCard } from './BlogContentCard-0be201aa.js';

const css = {
  code: ".slug.svelte-dlboxx{display:flex;flex-direction:column;padding:5rem 26rem}@media screen and (max-width: 1024px){.slug.svelte-dlboxx{padding:5rem 13rem}}@media screen and (max-width: 768px){.slug.svelte-dlboxx{padding:5rem 6.5rem}}.grid.svelte-dlboxx{display:grid;grid-template-columns:1fr;gap:2rem}@media screen and (min-width: 1280px){.grid.svelte-dlboxx{grid-template-columns:1fr 25rem}}.hero.svelte-dlboxx{display:flex;flex-direction:column;gap:1.5rem}.hero__image.svelte-dlboxx{width:100%;max-height:75rem;object-fit:cover}.hero__heading.svelte-dlboxx,.hero__subheading.svelte-dlboxx,.hero__date.svelte-dlboxx{color:#15181c;line-height:normal;white-space:pre-line}.hero__heading.svelte-dlboxx{font-size:3rem}.hero__subheading.svelte-dlboxx{font-size:1.8rem;font-weight:normal}.hero__date.svelte-dlboxx{font-size:1rem;margin:0}.tags.svelte-dlboxx{display:flex;flex-wrap:wrap;gap:0.5rem}.tag.svelte-dlboxx{font-size:1.2rem;padding:0.5rem 1rem;border-radius:4rem;background:#0e76bc}.post__content.svelte-dlboxx{color:#15181c;line-height:normal;white-space:pre-line;width:100%;font-size:1.8rem}.post__section.svelte-dlboxx{padding-block:2rem;display:flex;flex-direction:column;gap:1rem}.post__section--subtitle.svelte-dlboxx,.post__section--alt.svelte-dlboxx,.post__section--content.svelte-dlboxx{color:#15181c}.post__section--subtitle.svelte-dlboxx{font-size:2.6rem}.post__section--image.svelte-dlboxx{width:100%}.latest.svelte-dlboxx{height:min-content}.latest__heading.svelte-dlboxx{color:#2d3744;font-size:3rem;margin-bottom:2rem}.latest__grid.svelte-dlboxx{display:grid;grid-template-columns:repeat(auto-fit, minmax(20rem, 1fr));gap:2rem}@media screen and (max-width: 640px){.latest__grid.svelte-dlboxx{display:flex;flex-direction:column}}.latest__card.svelte-dlboxx{text-decoration:none;max-width:30rem}@media screen and (max-width: 640px){.latest__card.svelte-dlboxx{max-width:none}}",
  map: null
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let title;
  let changed_at;
  let description;
  let content;
  let hero;
  let tags;
  let sections;
  let alt;
  let { data } = $$props;
  if ($$props.data === void 0 && $$bindings.data && data !== void 0)
    $$bindings.data(data);
  $$result.css.add(css);
  ({ title, changed_at, description, content, hero, tags } = data.post);
  sections = data.post.sections;
  alt = `${title} blog post`;
  return `${$$result.head += `<!-- HEAD_svelte-1msh2dz_START -->${$$result.title = `<title>${escape(title)} | First Landings Aviation</title>`, ""}<meta name="description"${add_attribute("content", `First Landings Aviation ${title} blog post`, 0)}><!-- HEAD_svelte-1msh2dz_END -->`, ""}  <article class="slug svelte-dlboxx"><section class="hero svelte-dlboxx"><h2 class="hero__heading svelte-dlboxx">${escape(title)}</h2> <h3 class="hero__subheading svelte-dlboxx">${escape(description)}</h3> <p class="hero__date svelte-dlboxx">PUBLISHED: ${escape(formatDate(changed_at.split("T")[0]))}</p> <img class="hero__image svelte-dlboxx"${add_attribute("alt", alt, 0)}${add_attribute("src", hero, 0)}> <div class="tags svelte-dlboxx">${each(tags, (tag) => {
    return `<span class="tag svelte-dlboxx">#${escape(tag)}</span>`;
  })}</div></section> <div class="grid svelte-dlboxx">${data.post ? `<article class="post"> <p class="post__content post__content--main svelte-dlboxx"><!-- HTML_TAG_START -->${content}<!-- HTML_TAG_END --></p> ${each(sections, (section) => {
    return `<section class="post__section svelte-dlboxx"><h4 class="post__section--subtitle svelte-dlboxx">${escape(section.subtitle)}</h4> ${section.content_1 ? `<p class="post__content post__section--content svelte-dlboxx"><!-- HTML_TAG_START -->${section.content_1}<!-- HTML_TAG_END --> </p>` : ``} ${section.image ? `<img class="post__section--image svelte-dlboxx"${add_attribute("alt", section.image_alt, 0)}${add_attribute("src", section.image, 0)}> <pre class="post__section--alt svelte-dlboxx">${escape(section.image_alt)}</pre>` : ``} ${section.content_2 ? `<p class="post__content post__section--content svelte-dlboxx"><!-- HTML_TAG_START -->${section.content_2}<!-- HTML_TAG_END --> </p>` : ``} </section>`;
  })}</article>` : ``} <aside class="latest svelte-dlboxx"><h2 class="latest__heading svelte-dlboxx" data-svelte-h="svelte-n63cz8">Latest Posts</h2> <div class="latest__grid svelte-dlboxx">${each(data.posts, ({ published, slug, hero: hero2, title: title2, changed_at: changed_at2 }) => {
    return `${published && data.post.slug != slug ? `<a class="latest__card svelte-dlboxx" data-sveltekit-reload${add_attribute("href", `/blog/${slug}`, 0)}>${validate_component(BlogContentCard, "ContentCard").$$render(
      $$result,
      {
        small: true,
        src: hero2,
        alt: `${title2} blog post`
      },
      {},
      {
        main: () => {
          return `<div slot="main"><div>${escape(formatDate(changed_at2.split("T")[0]))}</div> </div>`;
        },
        title: () => {
          return `<div slot="title">${escape(title2)}</div>`;
        }
      }
    )} </a>` : ``}`;
  })}</div></aside></div></article> `;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-d5249e95.js.map
