import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { P as Prerequisites } from './Prerequisites-09460ce9.js';
import { A as AccountCowboyHatOutline } from './AccountCowboyHatOutline-388465b7.js';
import { C as ClipboardEdit } from './ClipboardEdit-b09fc415.js';
import { T as Turbine } from './Turbine-82ea90b2.js';
import { C as CheckDecagram } from './CheckDecagram-6513be28.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/multi_taxi.53be9638.avif 1x, /_app/immutable/assets/multi_taxi.4e73134b.avif 2x",
    webp: "/_app/immutable/assets/multi_taxi.8ab5e3f1.webp 1x, /_app/immutable/assets/multi_taxi.304d8e52.webp 2x",
    jpeg: "/_app/immutable/assets/multi_taxi.06eba42e.jpg 1x, /_app/immutable/assets/multi_taxi.1caa2c4a.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/multi_taxi.1caa2c4a.jpg",
    w: 4096,
    h: 2731
  }
};
const content_src = {
  sources: {
    avif: "/_app/immutable/assets/multi_landing.dfa23a16.avif 1x, /_app/immutable/assets/multi_landing.fbd495fe.avif 2x",
    webp: "/_app/immutable/assets/multi_landing.42bb59e9.webp 1x, /_app/immutable/assets/multi_landing.ff1db9ac.webp 2x",
    jpeg: "/_app/immutable/assets/multi_landing.7f36c174.jpg 1x, /_app/immutable/assets/multi_landing.fde08758.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/multi_landing.fde08758.jpg",
    w: 4096,
    h: 2731
  }
};
const css = {
  code: ".heading.svelte-117fmts{color:#15181c;font-size:3rem}",
  map: null
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Multi Engine Orientation",
        icon: AccountCowboyHatOutline
      },
      {
        label: "Multi Engine Training",
        icon: Turbine
      },
      {
        label: "Multi Engine Checkride",
        icon: ClipboardEdit
      },
      {
        label: "Multi Engine Add-on Achieved",
        icon: CheckDecagram
      }
    ]
  ];
  let prerequisites = {
    eligibility: [
      "Be at least 18 years of age",
      "Be English proficient",
      "Hold at least a private pilot certificate",
      "Receive a logbook endorsement from an authorized instructor who conducted the required ground training or reviewed your home study and certified that you are prepared for the required knowledge test",
      "Pass the required knowledge test",
      "Receive the required training and a logbook endorsement from an authorized instructor who conducted the training and certified that you are prepared for the required practical test",
      "Meet the aeronautical experience requirements",
      "Pass the required practical test",
      "Comply with the regulations"
    ],
    proficiency: [
      "Preflight preparation",
      "Preflight procedures",
      "Airport operations",
      "Takeoffs, landings, and go-arounds",
      "Performance maneuvers",
      "Multi-engine operations",
      "Navigation",
      "Slow flight and stalls",
      "Emergency operations",
      "High altitude operations",
      "Post-flight procedures"
    ],
    experience: [
      "Must have a logbook or training record endorsement from an authorized instructor attesting that the person was found competent in the appropriate aeronautical knowledge areas and proficient in the appropriate areas of operation",
      "Must pass the practical test",
      "<b>Note:</b> Expect around 10 hours of training"
    ]
  };
  $$result.css.add(css);
  return `${$$result.head += `<!-- HEAD_svelte-13ozva2_START -->${$$result.title = `<title>Multi Engine Rating | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation multi engine pilot training"><!-- HEAD_svelte-13ozva2_END -->`, ""} ${validate_component(Hero, "Hero").$$render($$result, { alt: "", src: hero_src }, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-10io3ci">A Multi Engine Rating enables you to serve as the pilot-in-command (PIC) of aircraft
		equipped with multiple engines. Obtaining this rating is essential for aspiring pilots
		looking to pursue a career in the airline industry or enhance their skill level which looks
		great to potential employers in the aviation field, especially when it comes from a school
		known for its high-quality training.</div>`;
    },
    titleTwo: () => {
      return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-17hb5a7">Rating</span>`;
    },
    titleOne: () => {
      return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1icfhhl">Multi Engine</span>`;
    }
  })} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Tecnam P2006t landing",
          src: content_src
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-16f4cl">At First Landings Aviation, you’ll train in a well-maintained Tecnam P2006t, a 4-seat
			twin engine airplane equipped for IFR flight. If you do not aspire to a career in
			professional aviation, remember that many hobbyist pilots fly multi-engine airplanes for
			the greater range and cargo capabilities as well as the security of flying with a second
			engine.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-5ixz1r">Course Description</span>`;
          }
        }
      )} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main">This comprehensive program offers:
			<br> <br> <ul data-svelte-h="svelte-59u7ci"><li>Computer Based Training (CBT) for P2006t cockpit layout;</li> <br> <li>10 hours of dual aircraft rental with an MEI;</li> <br> <li>2 hours of aircraft rental for the checkride;</li> <br> <li>10 hours of dedicated ground instruction</li> <br> <li>Comprehensive First Landings supplementary study materials: And,</li> <br> <li>Check-ride fees.</li></ul> <br> <br>
			The complete program’s total cost is $7,742 and is an excellent opportunity for you to master
			multi-engine flight.
			<br> <br>
			To secure your spot in the program and gain access to some exciting benefits, we kindly request
			a $1,000 deposit and acceptance of the program forms. The deposit will be applied toward
			your program costs, and the remaining balance will be due before your first scheduled flight
			session.
			<br> <br>
			Payment Options:
			<br> <br>
			Once you enroll into our program, we will create and enroll you into our scheduling software
			using
			<a href="https://app.flightschedulepro.com/Account/Signup/62297" target="_blank"${add_styles({ "color": `#15181c` })} data-svelte-h="svelte-ep66zg">Flight Schedule Pro (FSP)</a>, so that you are able to enter your information.
			<br> <br>
			Once you have updated your information, you will be able to conveniently pay the required
			deposit online via Flight Schedule Pro, and we will assign your primary instructor.
			<br> <br>
			Alternatively, if you prefer other payment methods, we will provide wire or ACH bank transfer
			information. If have any questions, please feel free to
			<a href="/contact-us"${add_styles({ "color": `#15181c` })} data-svelte-h="svelte-pe5eol">contact</a> our administrative team. We are
			here to assist you.
			<br> <br>
			Exclusive Benefits:
			<br> <br>
			Once your deposit is received, you will unlock some of our exclusive benefits:
			<br> <br> <ul data-svelte-h="svelte-d3k0gd"><li>Computer-Based Training (CBT): You will gain access to our comprehensive
					Computer- Based Training (CBT) course, which is a valuable resource designed to
					supplement your ground instruction. The CBT course will provide you with
					in-depth knowledge and practical insights to enhance your multi-engine training.</li> <br> <li>Checkride Booking: We will book your Multi-Engine Add-On checkride with a
					Designated Pilot Examiner. Once you select an available date, we will confirm
					the check-ride date is secured at the time of booking. The DPE fee is included
					as part of the package.</li> <br> <li>Study Materials: In addition to the CBT modules, we have compiled a selection of
					supplementary course materials to help you along the way. These materials
					include textbooks, reference guides, and online resources that will enhance your
					understanding and support your learning journey. Once you have enrolled, we will
					send an additional email with the links for the study materials.</li></ul> <br> <br>
			At First Landings Aviation, we are dedicated to providing you with a safe, immersive, and
			enjoyable learning experience as you embark on your multi-engine flight journey.
			<br> <br>
			Should you have any questions or need further information about the Multi-Engine Program,
			payment options, scheduling, or accessing the CBT course, please do not hesitate to reach
			out to our administrative team. We are here to assist you every step of the way.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-14xj7bh">We are thrilled to introduce our Multi-Engine Program at First Landings Aviation,
			designed to elevate your aviation skills to new heights</span>`;
        }
      })} <h2 class="heading svelte-117fmts" data-svelte-h="svelte-rztgv6">Why should you get a Multi-Engine Rating?</h2> ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-eot2r4">If you begin having engine trouble, your only solution in a single engine airplane is to
			land immediately. With more than one engine, you can continue flying toward a more
			suitable landing spot if you have a mechanical problem with an engine.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1cyy3m8">1) Two engines are (usually) safer than one</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, { color: "blue" }, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-mnor9u">Most multi-engine airplanes are substantially faster than similarly sized single engine
			counterparts. To complete a trip quickly, consider using a multi-engine airplane.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1esu3sh">2) You’ll fly faster</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-1m7ocw0">Whether it’s carrying more passengers or more equipment, multi-engine airplanes usually
			have a higher available payload than single engine aircraft of similar size. Plus, they
			look pretty cool on the ramp!</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-5hjoto">3) How about a size upgrade?</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, { color: "blue" }, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-1sxyp1d">In the past, airlines and charter companies have required new hire pilots to apply with
			hundreds of multi-engine flight hours. The hiring market is booming right now, and many
			of those requirements have disappeared for the time being, however that won’t be the
			case forever! The more multi-engine time you have, the more competitive you’ll be in a
			hiring market.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1kr0hoi">4) Multi-Engine flight time is valuable</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-1k7dtac">According to FAR 61.63(c), there is no minimum time requirement to add a multi-engine
			rating to your pilot certificate under Part 61, and you don’t have to take a new FAA
			written test. After 10-15 hours of flight training, your multi-engine instructor can
			sign you off to take the FAA practical test. For many people, a multi-engine add-on can
			be accomplished over just a few weeks. Ask us about our accelerated multi-engine
			training that we have available. Adding an MEL rating will make you a better, more
			confident pilot. Reference the FAA Private Pilot or Commercial Pilot ACS to see what
			your training requirements are.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1f1z22x">5) Getting a MEL add-on rating is easy</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, { color: "blue" }, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-4u6csh">If you want to be a professional pilot, full time or part time, having a multi-engine
			rating will open the doors to many more job opportunities. Many charter companies fly
			light twins like Cessna 414s or King Airs, with clients on board.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-utub4h">6) Open up more job opportunities</span>`;
        }
      })} ${validate_component(Prerequisites, "Prerequisites").$$render($$result, { prerequisites }, {}, {})}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-7e0e7880.js.map
