import { c as create_ssr_component, a as subscribe, o as onDestroy, b as add_attribute, v as validate_component, f as each, e as escape } from './ssr-73f02b7a.js';
import { w as writable } from './index2-caf24a5d.js';
import { B as BlogContentCard, f as formatDate } from './BlogContentCard-0be201aa.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { I as Input } from './Input-aeb2b456.js';

const createSearchStore = (data) => {
  const { subscribe: subscribe2, set, update } = writable({
    data,
    filtered: data,
    search: ""
  });
  return {
    subscribe: subscribe2,
    set,
    update
  };
};
const searchHandler = (store) => {
  const searchTerm = store.search.toLowerCase() || "";
  store.filtered = store.data.filter((item) => {
    return item.searchTerms.toLowerCase().includes(searchTerm);
  });
};
const Magnify = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const css = {
  code: ".heading.svelte-17gi7ty{color:#15181c;font-size:3rem}.flex.svelte-17gi7ty{display:flex;justify-content:space-between;align-items:center}.grid.svelte-17gi7ty{display:grid;grid-template-columns:repeat(auto-fit, minmax(35rem, 1fr));gap:5rem}@media screen and (max-width: 640px){.grid.svelte-17gi7ty{grid-template-columns:1fr}}.card.svelte-17gi7ty{text-decoration:none}",
  map: null
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let $searchStore, $$unsubscribe_searchStore;
  let { data } = $$props;
  let MagnifyIcon = Magnify;
  const searchPosts = data.posts.createSearchTerms();
  const searchStore = createSearchStore(searchPosts);
  $$unsubscribe_searchStore = subscribe(searchStore, (value) => $searchStore = value);
  const unsubscribe = searchStore.subscribe((model) => searchHandler(model));
  onDestroy(() => {
    unsubscribe();
  });
  if ($$props.data === void 0 && $$bindings.data && data !== void 0)
    $$bindings.data(data);
  $$result.css.add(css);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${$$result.head += `<!-- HEAD_svelte-sxb8qp_START -->${$$result.title = `<title>Blog | First Landings Aviation</title>`, ""}<meta name="description"${add_attribute("content", "First Landings Aviation blog", 0)}><!-- HEAD_svelte-sxb8qp_END -->`, ""} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
      default: () => {
        return `<div class="flex svelte-17gi7ty"><h2 class="heading svelte-17gi7ty" data-svelte-h="svelte-1ksj517">Latest Posts</h2> ${validate_component(Input, "Input").$$render(
          $$result,
          {
            name: "search",
            invalid: false,
            left_icon: MagnifyIcon,
            placeholder: "Search",
            type: "text",
            value: $searchStore.search
          },
          {
            value: ($$value) => {
              $searchStore.search = $$value;
              $$settled = false;
            }
          },
          {}
        )}</div> <div class="grid svelte-17gi7ty">${each($searchStore.filtered, ({ slug, hero, title, changed_at, description, published }) => {
          return `${published ? `<a class="card svelte-17gi7ty" data-sveltekit-reload${add_attribute("href", `/blog/${slug}`, 0)}>${validate_component(BlogContentCard, "ContentCard").$$render($$result, { src: hero, alt: `${title} blog post` }, {}, {
            main: () => {
              return `<div slot="main"><div>${escape(formatDate(changed_at.split("T")[0]))}</div> </div>`;
            },
            title: () => {
              return `<div slot="title">${escape(title)}</div>`;
            }
          })} </a>` : ``}`;
        })}</div>`;
      }
    })}`;
  } while (!$$settled);
  $$unsubscribe_searchStore();
  return $$rendered;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-53406ae6.js.map
