import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { P as Prerequisites } from './Prerequisites-09460ce9.js';
import { I as Image } from './Image-c986cba7.js';
import { C as CastEducation } from './CastEducation-a03ba997.js';
import { A as AirplaneClock } from './AirplaneClock-cb0f1431.js';
import { C as ClipboardEdit } from './ClipboardEdit-b09fc415.js';
import { C as CheckDecagram } from './CheckDecagram-6513be28.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/clouds_blue_sky_hero.2bbc6518.avif 1x, /_app/immutable/assets/clouds_blue_sky_hero.df4dfd86.avif 2x",
    webp: "/_app/immutable/assets/clouds_blue_sky_hero.e0419c01.webp 1x, /_app/immutable/assets/clouds_blue_sky_hero.054308c1.webp 2x",
    jpeg: "/_app/immutable/assets/clouds_blue_sky_hero.235b3730.jpg 1x, /_app/immutable/assets/clouds_blue_sky_hero.2c773218.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/clouds_blue_sky_hero.2c773218.jpg",
    w: 4e3,
    h: 2658
  }
};
const content_src1 = {
  sources: {
    avif: "/_app/immutable/assets/wing_tip_cloud.dc2b4121.avif 1x, /_app/immutable/assets/wing_tip_cloud.c45e7342.avif 2x",
    webp: "/_app/immutable/assets/wing_tip_cloud.ae791a98.webp 1x, /_app/immutable/assets/wing_tip_cloud.3338c4d9.webp 2x",
    jpeg: "/_app/immutable/assets/wing_tip_cloud.c590db79.jpg 1x, /_app/immutable/assets/wing_tip_cloud.17abcd3d.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/wing_tip_cloud.17abcd3d.jpg",
    w: 6e3,
    h: 4e3
  }
};
const content_src2 = {
  sources: {
    avif: "/_app/immutable/assets/instrument_checkride.cd3d4a11.avif 1x, /_app/immutable/assets/instrument_checkride.6abc4fa6.avif 2x",
    webp: "/_app/immutable/assets/instrument_checkride.258f4e20.webp 1x, /_app/immutable/assets/instrument_checkride.d02f2a41.webp 2x",
    jpeg: "/_app/immutable/assets/instrument_checkride.daf6525d.jpg 1x, /_app/immutable/assets/instrument_checkride.7d2885ef.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/instrument_checkride.7d2885ef.jpg",
    w: 6e3,
    h: 4e3
  }
};
const image_src = {
  sources: {
    avif: "/_app/immutable/assets/thumbs_up.78ee799f.avif 1x, /_app/immutable/assets/thumbs_up.62b5ba11.avif 2x",
    webp: "/_app/immutable/assets/thumbs_up.e46e8315.webp 1x, /_app/immutable/assets/thumbs_up.d744ef02.webp 2x",
    jpeg: "/_app/immutable/assets/thumbs_up.2404d64a.jpg 1x, /_app/immutable/assets/thumbs_up.d9b2660e.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/thumbs_up.d9b2660e.jpg",
    w: 6e3,
    h: 4e3
  }
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Time Building",
        icon: AirplaneClock
      },
      {
        label: "Instrument Training",
        icon: CastEducation
      },
      {
        label: "Instrument Checkride",
        icon: ClipboardEdit
      },
      {
        label: "Instrument Add-on Acheived",
        icon: CheckDecagram
      }
    ]
  ];
  let prerequisites = {
    eligibility: [
      "Hold at least a current private pilot certificate",
      "Be able to read, speak, write, and understand the English language proficiently",
      "Receive and log ground training from an authorized instructor or complete a home-study course on the aeronautical knowledge areas that apply to the instrument rating sought",
      "Have an instructor certify that you are prepared for the required knowledge test",
      "Receive and log training on the areas of operation",
      "Have an instructor certify that you are prepared for the required practical test",
      "Pass the knowledge test on aeronautical knowledge",
      "Pass the practical test"
    ],
    proficiency: [
      "Preflight preparation",
      "Preflight procedures",
      "Air traffic control clearances and procedures",
      "Flight by reference to instruments",
      "Navigation systems",
      "Instrument approach procedures",
      "Emergency operations",
      "Post-flight procedures"
    ],
    experience: [
      "50 hours of cross-country as pilot in command, 10 hours in an airplane",
      "40 hours of instrument time of which 15 hours must have been dual received from an instructor who holds an instrument-airplane rating and the instrument time includes:",
      "(a) 3 hours of instrument flight training from an instructor in an airplane that is appropriate to the instrument-airplane rating within 2 calendar months before the date of the practical test",
      "(b) Instrument flight training on cross country flight procedures, including one cross country flight in an airplane with an instructor, that is performed under instrument flight rules, when a flight plan has been filed with an air traffic control facility, and that involves:",
      "(i) A flight of 250 nautical miles along airways or by directed routing from an air traffic control facility",
      "(ii) An instrument approach at each airport",
      "(iii) Three different kinds of approaches with the use of navigation systems"
    ]
  };
  return `${$$result.head += `<!-- HEAD_svelte-l5wo8g_START -->${$$result.title = `<title>Instrument Rating | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation airplane instrument training"><!-- HEAD_svelte-l5wo8g_END -->`, ""} ${validate_component(Hero, "Hero").$$render($$result, { alt: "", src: hero_src }, {}, {
    main: () => {
      return `<div slot="main" data-svelte-h="svelte-10koc5c">Instrument flight training deepens your understanding of subjects covered in private pilot
        training and incorporates specific knowledge related to flying in instrument meteorological
        conditions. Instrument-rated pilots can file IFR flight plans, allowing them to fly through
        clouds and navigate challenging airspace in a safer way and with greater ease.</div>`;
    },
    titleTwo: () => {
      return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1qwng4j">Rating</span>`;
    },
    titleOne: () => {
      return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-18bhird">Instrument</span>`;
    }
  })} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Clouds outside airplane window",
          src: content_src1
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-9tciq1">At First Landings Aviation Pilot Center, we will teach you to perfect your instrument
            flying skills by flying in actual weather conditions, as well as what factors to
            consider when making a go/no-go decision. Our instructors have experience in almost all
            weather conditions and we encourage students to gain that experience with us before
            attempting it on their own voluntarily or involuntarily. We try to cater our training to
            each individual student. Depending on your schedule you may be interested in our
            self-paced training option or our accelerated immersion course.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1vy11x7">Course Description</span>`;
          }
        }
      )} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-93qjcc">In order to obtain your instrument rating, you must be able to read, speak, write, and
            understand the English language proficiently and be at least 17 years of age. You will
            also need a medical certificate (third class or better) from an FAA approved aviation
            medical examiner (AME), proof of U.S citizenship or TSA approval, as well as a private
            pilot certificate.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-17oidz4">What Do You Need to Start?</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Pilot instrument check-ride pass",
          src: content_src2
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-k4xgje">A check-ride is an essential part of the pilot certification process that includes both
            a flight test and an oral exam. During a check-ride, a designated pilot examiner (DPE)
            assesses the pilot&#39;s ability to operate an aircraft safely and proficiently. The
            examination covers various aspects, including flight maneuvers, navigation, emergency
            procedures, communication skills, and a thorough understanding of aviation regulations.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-cuvss2">Checkride Information</span>`;
          }
        }
      )} ${validate_component(Prerequisites, "Prerequisites").$$render($$result, { prerequisites }, {}, {})} ${validate_component(Image, "Image").$$render(
        $$result,
        {
          alt: "Thumbs up while taxiing an airplane",
          src: image_src
        },
        {},
        {}
      )}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-4f4cd200.js.map
