import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { I as Image } from './Image-c986cba7.js';
import { I as Included, E as Equal } from './Equal-6ddfaeca.js';
import { F as FridgeMagnet, P as Plus } from './Plus-6453516c.js';
import { A as AccountCowboyHatOutline } from './AccountCowboyHatOutline-388465b7.js';
import { B as BookOpenPageVariant } from './BookOpenPageVariant-8d667132.js';
import { A as AirplaneTakeoff } from './AirplaneTakeoff-bb9ec5c6.js';
import { C as CheckDecagram } from './CheckDecagram-6513be28.js';
import { C as CastEducation } from './CastEducation-a03ba997.js';
import { A as AirplaneClock } from './AirplaneClock-cb0f1431.js';
import { C as ClipboardEdit } from './ClipboardEdit-b09fc415.js';
import { T as Turbine } from './Turbine-82ea90b2.js';
import { H as HumanMaleBoard, N as NotebookCheckOutline, A as AccountSupervisor, B as BookEducation, S as School, a as AccountTieHat } from './School-36f73e07.js';

const css = {
  code: ".container.svelte-ik7fzr{padding:0 5rem 5rem 5rem}@media(max-width: 1280px){.container.svelte-ik7fzr{padding:0}}.container__heading.svelte-ik7fzr{text-align:left;max-width:none;font-size:2rem;font-weight:700;color:#15181c;margin-bottom:3rem;margin-left:2.5rem}@media screen and (max-width: 768px){.container__heading.svelte-ik7fzr{text-align:center;margin-left:0}}.Career.svelte-ik7fzr{display:flex;flex-direction:column;align-items:center;background-image:linear-gradient(to right, #f36d21 0%, #f36d21 50%, #0e76bc 50%, #0e76bc 100%);border-radius:2rem;padding:2.5rem 10rem;gap:5rem}@media(max-width: 1280px){.Career.svelte-ik7fzr{border-radius:0}}.Career__heading.svelte-ik7fzr{font-size:2.5rem;max-width:none;color:#fff;display:flex;flex-direction:column;align-items:center;gap:2rem;text-align:center}.Career__icons.svelte-ik7fzr{align-self:center}.topContainer.svelte-ik7fzr{display:flex;gap:2rem}@media screen and (max-width: 1280px){.topContainer.svelte-ik7fzr{gap:1rem}}@media screen and (max-width: 1024px){.topContainer.svelte-ik7fzr{display:grid;grid-template-columns:1fr;justify-items:center}}.bottomContainer.svelte-ik7fzr{display:flex;gap:5rem;flex-wrap:wrap;justify-content:center}.rates__card.svelte-ik7fzr{display:flex;flex-direction:column;align-items:center;gap:2.5rem;padding:2.5rem 0.5rem;border:0.3rem solid #f36d21;border-radius:1.5rem;background-color:#fff;color:#15181c;width:20rem;justify-content:center}@media screen and (max-width: 1024px){.rates__card.svelte-ik7fzr{width:75%;max-width:none;margin:0 auto;width:40rem}}.rates__card--icon.svelte-ik7fzr{width:80%;display:flex;justify-content:center;align-items:center}.rates__card--title.svelte-ik7fzr{text-align:center;font-size:1.6rem;font-weight:600}.rates__card--values.svelte-ik7fzr{display:flex;flex-direction:column;align-items:center;gap:1rem;text-align:center;font-weight:600}.rates__card--small.svelte-ik7fzr{width:31rem;height:17rem;gap:1.8rem}.blue.svelte-ik7fzr{border:0.3rem solid #0e76bc}.values__price.svelte-ik7fzr{font-size:1.6rem;padding:0;margin:0}.separator.svelte-ik7fzr{border-top:0.1rem solid #f36d21;width:90%}.separatorBlue.svelte-ik7fzr{border-top:0.1rem solid #0e76bc;width:90%}",
  map: null
};
const Career = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  $$result.css.add(css);
  return `<div class="container svelte-ik7fzr"><section class="container__heading svelte-ik7fzr" data-svelte-h="svelte-i8lij2"><h2 class="container__heading--h2">The Full Package</h2></section> <article class="Career svelte-ik7fzr"><section class="Career__heading svelte-ik7fzr"><div class="Career__heading--icon">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#fff" }, {}, {})}</div> <h2 class="Career__heading--h2" data-svelte-h="svelte-30v6nl">Commit to Your Aviation Career</h2></section> <div class="topContainer svelte-ik7fzr"><section class="rates__card blue svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#0e76bc" }, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-1mtq53p">Private Pilot</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-eexv20"><h3 class="values__title--mobile">Rental Hours</h3> <p class="values__price svelte-ik7fzr">40hrs</p> <hr class="separatorBlue svelte-ik7fzr"> <h3 class="values__title--mobile">Instruction</h3> <p class="values__price svelte-ik7fzr">25hrs</p> <hr class="separatorBlue svelte-ik7fzr"> <h3 class="values__title--mobile">Ground</h3> <p class="values__price svelte-ik7fzr">10hrs</p></div></section> <div class="Career__icons svelte-ik7fzr">${validate_component(Plus, "Plus").$$render($$result, { color: "white", size: "5rem" }, {}, {})}</div> <section class="rates__card blue svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#0e76bc" }, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-1pb9nya">Instrument Rating</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-osderf"><h3 class="values__title--mobile">Rental Hours</h3> <p class="values__price svelte-ik7fzr">20hrs</p> <hr class="separatorBlue svelte-ik7fzr"> <h3 class="values__title--mobile">Instruction</h3> <p class="values__price svelte-ik7fzr">15hrs</p> <hr class="separatorBlue svelte-ik7fzr"> <h3 class="values__title--mobile">Ground</h3> <p class="values__price svelte-ik7fzr">10hrs</p></div></section> <div class="Career__icons svelte-ik7fzr">${validate_component(Plus, "Plus").$$render($$result, { color: "white", size: "5rem" }, {}, {})}</div> <section class="rates__card svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, {}, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-7juhaw">Commercial SEL</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-fee2of"><h3 class="values__title--mobile">Rental Hours</h3> <p class="values__price svelte-ik7fzr">25hrs</p> <hr class="separator svelte-ik7fzr"> <h3 class="values__title--mobile">Instruction</h3> <p class="values__price svelte-ik7fzr">25hrs</p> <hr class="separator svelte-ik7fzr"> <h3 class="values__title--mobile">Ground</h3> <p class="values__price svelte-ik7fzr">10hrs</p></div></section> <div class="Career__icons svelte-ik7fzr">${validate_component(Equal, "Equal").$$render($$result, { color: "white", size: "5rem" }, {}, {})}</div> <section class="rates__card svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, {}, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-eu2p8a">All the Hours You Need</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-1e9470u"><h3 class="values__title--mobile">Rental Hours</h3> <p class="values__price svelte-ik7fzr">260hrs</p> <hr class="separator svelte-ik7fzr"> <h3 class="values__title--mobile">Instruction</h3> <p class="values__price svelte-ik7fzr">65hrs</p> <hr class="separator svelte-ik7fzr"> <h3 class="values__title--mobile">Ground</h3> <p class="values__price svelte-ik7fzr">30hrs</p></div></section></div> <section class="Career__heading svelte-ik7fzr"><div class="Career__heading--icon">${validate_component(Plus, "Plus").$$render($$result, { color: "#fff", size: "5rem" }, {}, {})}</div> <h2 class="Career__heading--h2" data-svelte-h="svelte-120ar6r">Add-Ons</h2></section> <div class="bottomContainer svelte-ik7fzr"><section class="rates__card rates__card--small blue svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#0e76bc" }, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-1dqv3jw">Certified Flight Instructor</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-1agqb25"><p class="values__price svelte-ik7fzr">$8,560.00</p></div></section> <section class="rates__card rates__card--small blue svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#0e76bc" }, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-101vro">Commercial Multi-Engine</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-cvkx8h"><p class="values__price svelte-ik7fzr">$7,703.00</p></div></section> <section class="rates__card rates__card--small svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, {}, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-1wt45wt">Certified Flight Instructor Instrument</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-1agqb25"><p class="values__price svelte-ik7fzr">$8,560.00</p></div></section> <section class="rates__card rates__card--small svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#0e76bc" }, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-o4lx2c">Certified Flight Instructor Multi-Engine</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-10psz2i"><p class="values__price svelte-ik7fzr">$8,253.00</p></div></section> <section class="rates__card rates__card--small blue svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, { color: "#0e76bc" }, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-1uup4b6">50 hours of Multi-Engine Time Building</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-wwk0d4"><p class="values__price svelte-ik7fzr">$18,300.00</p></div></section> <section class="rates__card rates__card--small svelte-ik7fzr"><div class="rates__card--icon svelte-ik7fzr">${validate_component(FridgeMagnet, "Magnet").$$render($$result, {}, {}, {})}</div> <h3 class="rates__card--title svelte-ik7fzr" data-svelte-h="svelte-rv59oo">9 Months Housing (Double Occupancy)</h3> <div class="rates__card--values svelte-ik7fzr" data-svelte-h="svelte-1mx7cq1"><p class="values__price svelte-ik7fzr">$18,000</p></div></section></div></article> </div>`;
});
const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/flying_looking_at_camera.dedb8c61.avif 1x, /_app/immutable/assets/flying_looking_at_camera.a6585b89.avif 2x",
    webp: "/_app/immutable/assets/flying_looking_at_camera.85f17e6a.webp 1x, /_app/immutable/assets/flying_looking_at_camera.2a82a5bd.webp 2x",
    png: "/_app/immutable/assets/flying_looking_at_camera.8f3532d0.png 1x, /_app/immutable/assets/flying_looking_at_camera.78f2f5a1.png 2x"
  },
  img: {
    src: "/_app/immutable/assets/flying_looking_at_camera.78f2f5a1.png",
    w: 4096,
    h: 2732
  }
};
const content_src = {
  sources: {
    avif: "/_app/immutable/assets/explaining.2982a04a.avif 1x, /_app/immutable/assets/explaining.270d6a91.avif 2x",
    webp: "/_app/immutable/assets/explaining.363ecbdd.webp 1x, /_app/immutable/assets/explaining.7f84c6f3.webp 2x",
    jpeg: "/_app/immutable/assets/explaining.20ab98c1.jpg 1x, /_app/immutable/assets/explaining.b62ff750.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/explaining.b62ff750.jpg",
    w: 6e3,
    h: 4e3
  }
};
const image_src = {
  sources: {
    avif: "/_app/immutable/assets/learning.e0334fc0.avif 1x, /_app/immutable/assets/learning.8fd6b8cc.avif 2x",
    webp: "/_app/immutable/assets/learning.6ed250d4.webp 1x, /_app/immutable/assets/learning.559f652a.webp 2x",
    jpeg: "/_app/immutable/assets/learning.fe5d5d93.jpg 1x, /_app/immutable/assets/learning.ff8b2d32.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/learning.ff8b2d32.jpg",
    w: 6e3,
    h: 4e3
  }
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Orientation / Discover flight",
        icon: AccountCowboyHatOutline
      },
      {
        label: "Private Pilot Training",
        icon: BookOpenPageVariant
      },
      {
        label: "Private Pilot Checkride",
        icon: AirplaneTakeoff
      },
      {
        label: "Private Pilot Acheived",
        icon: CheckDecagram
      }
    ],
    [
      {
        label: "Time Building",
        icon: AirplaneClock
      },
      {
        label: "Instrument Training",
        icon: CastEducation
      },
      {
        label: "Instrument Checkride",
        icon: ClipboardEdit
      },
      {
        label: "Instrument Add-on Acheived",
        icon: CheckDecagram
      }
    ],
    [
      {
        label: "Time building",
        icon: AirplaneClock
      },
      {
        label: "Commercial Pilot Training",
        icon: BookOpenPageVariant
      },
      {
        label: "Commercial Pilot Checkride",
        icon: AirplaneTakeoff
      },
      {
        label: "Commercial Pilot Achieved",
        icon: CheckDecagram
      }
    ],
    [
      {
        label: "Multi Engine Orientation",
        icon: AccountCowboyHatOutline
      },
      {
        label: "Multi Engine Training",
        icon: Turbine
      },
      {
        label: "Multi Engine Checkride",
        icon: ClipboardEdit
      },
      {
        label: "Multi Engine Add-on Achieved",
        icon: CheckDecagram
      }
    ],
    [
      {
        label: "CFI Training",
        icon: HumanMaleBoard
      },
      {
        label: "CFI Checkride",
        icon: NotebookCheckOutline
      },
      {
        label: "Start Instructing Students",
        icon: AccountSupervisor
      },
      {
        label: "CFII Course",
        icon: BookEducation
      }
    ],
    [
      {
        label: "CFII Checkride",
        icon: AirplaneTakeoff
      },
      { label: "MEI Course", icon: School },
      {
        label: "MEI Checkride",
        icon: AirplaneTakeoff
      },
      {
        label: "1500 Hours Achieved",
        icon: AccountTieHat
      }
    ]
  ];
  return `${$$result.head += `<!-- HEAD_svelte-13oc3l4_START -->${$$result.title = `<title>Career Pilot | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation professional pilot training"><!-- HEAD_svelte-13oc3l4_END -->`, ""} ${validate_component(Hero, "Hero").$$render(
    $$result,
    {
      alt: "",
      src: hero_src,
      top: 0,
      translate: "-50%, 0"
    },
    {},
    {
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-cc7qgh">First Landings career pilot program prepares students for a variety of rewarding careers in
        aviation. Attending our structured, high quality airline pilot training ensures that you
        receive a solid foundation in all of the fundamentals that make up a well-rounded aviation
        education. With connections to the world’s best airlines and programs through our industry
        contacts, we produce top quality pilots and personnel that exceed commercial airline
        standards. Our students are sought after by flight departments and airlines around the world
        because they know that our students aren’t just great aviators, they have been trained to be
        professional pilots.</div>`;
      },
      titleTwo: () => {
        return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-16bqbb0">Pilot Program</span>`;
      },
      titleOne: () => {
        return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-uyicq7">Professional</span>`;
      }
    }
  )} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render(
        $$result,
        {
          alt: "Instructor teaching student pilot preflight",
          src: content_src
        },
        {},
        {
          main: () => {
            return `<div slot="main" data-svelte-h="svelte-1gion40">We&#39;re welcoming students to start an exciting journey toward becoming a Commercial
            Airline Pilot. New pilot certification rules have caused a shortage of qualified pilots
            in the aviation industry, affecting both commercial and airline pilots. Our First
            Landings career pilot program helps prepare students for fulfilling careers in aviation.</div>`;
          },
          title: () => {
            return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-s0qcwk">Begin Your Journey at First Landings Aviation</span>`;
          }
        }
      )} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-1jbwiml">Do you enjoy exploring new destinations? Becoming a pilot is a fantastic way to see the
            world while getting paid for it. When you work for an airline, you can also take
            advantage of affordable travel during your leisure time, including free flights and
            discounts on hotels, rental cars, and tours.
            <br> <br>
            Being a pilot isn&#39;t a typical 9-to-5 job, and it may involve working nights or weekends occasionally.
            However, pilots often enjoy more time off compared to those in traditional jobs. Senior pilots
            at major airlines might have schedules with as few as seven workdays a month, while junior
            pilots at regional airlines frequently get blocks of three to five days off.
            <br> <br>
            Another exciting part of being a pilot is the challenge it brings. Flying a plane demands
            a mix of technical knowledge, decision-making abilities, and hand-eye coordination. Pilots
            find their job fulfilling because it combines mental and physical skills, making each workday
            different. Plus, they get to enjoy the best view from their &quot;office&quot; and they don&#39;t bring
            work home with them.
            <br> <br>
            Pay is a crucial part of any job. Senior captains flying large planes like the Boeing 747
            or Airbus A380 can make up to $400,000 per year. While not all pilots earn this much, airline
            captains with a decade of experience usually make around $150,000 or more yearly at major
            airlines and about $80,000 per year at regional airlines. Additionally, pilots usually receive
            benefits like health insurance, life insurance, and 401K as part of their compensation.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1v4b0t8">We are Experts in the Aviation Training Industry</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, { color: "blue" }, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-bj3a0i">Today the demand for pilots is outpacing the rate at which we can teach them. Current
            pilot job offers exceed $60k your first year with sign on bonuses.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-14zp9pz">Immediate Job Openings</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, { color: "blue" }, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-t2porp">With connections to the world’s best airlines and programs through our industry
            contacts, we produce top quality pilots and personnel that exceed commercial airline
            standards.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-102yfln">Connections</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, { color: "blue" }, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-18i4co2">Our program can take you from hour 0 to your multi engine commercial in as little as 6
            months. After completing the course, you have the opportunity to be hired on as a CFI at
            First Landings Aviation.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-12hnros">0-Hour to Commercial Pilot</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-54ua8w">Receiving proper training is crucial to a pilot’s success, regardless of the career path
            they choose to pursue. Every job interview will test a pilot’s knowledge and flight
            skills because employers want to hire the most qualified pilot possible. Attending First
            Landings’ structured, high quality commercial airline pilot school training ensures that
            you receive a solid foundation in all of the fundamentals that make up a well-rounded
            aviation education. Our students are sought after by flight departments and airlines
            around the world because they know that our students aren’t just great aviators, they
            have been trained to be professional pilots.
            <br> <br>
            First Landings recognizes that one size does not fit all. We have programs designed for students
            that wish to attend the school full-time and complete their training in the shortest time
            possible. Our self-paced program is designed for students who wish to continue working while
            training, and features one-on-one ground school with the same great flight instruction. Both
            options will get you to your ultimate goal.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-kw0vnc">Start Your Career Today</span>`;
        }
      })} ${validate_component(Image, "Image").$$render(
        $$result,
        {
          alt: "Instructor teaching student pilot preflight",
          src: image_src
        },
        {},
        {}
      )}`;
    }
  })} ${validate_component(Included, "Included").$$render($$result, {}, {}, {})} ${validate_component(Career, "Career").$$render($$result, {}, {}, {})}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-49984f82.js.map
