import { c as create_ssr_component, v as validate_component, d as add_styles } from './ssr-73f02b7a.js';
import { W as Wrapper } from './Wrapper-76875b77.js';
import { H as Hero } from './Hero-04d60013.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';
import { R as Roadmap } from './Roadmap-b89b5076.js';
import { I as Image } from './Image-c986cba7.js';
import { B as Button } from './Button-b4fad8e7.js';
import { B as BookOpenPageVariant } from './BookOpenPageVariant-8d667132.js';
import { C as CastEducation } from './CastEducation-a03ba997.js';
import { T as Turbine } from './Turbine-82ea90b2.js';

const hero_src = {
  sources: {
    avif: "/_app/immutable/assets/xander.27d71fd6.avif 1x, /_app/immutable/assets/xander.488cecb8.avif 2x",
    webp: "/_app/immutable/assets/xander.1922dad6.webp 1x, /_app/immutable/assets/xander.9739fadb.webp 2x",
    jpeg: "/_app/immutable/assets/xander.18e370c9.jpg 1x, /_app/immutable/assets/xander.9ade801b.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/xander.9ade801b.jpg",
    w: 4032,
    h: 3025
  }
};
const image_src = {
  sources: {
    avif: "/_app/immutable/assets/multi_achieved.0158948c.avif 1x, /_app/immutable/assets/multi_achieved.19731a8a.avif 2x",
    webp: "/_app/immutable/assets/multi_achieved.d749a85e.webp 1x, /_app/immutable/assets/multi_achieved.70ad41c0.webp 2x",
    jpeg: "/_app/immutable/assets/multi_achieved.0648a390.jpg 1x, /_app/immutable/assets/multi_achieved.d2d14e82.jpg 2x"
  },
  img: {
    src: "/_app/immutable/assets/multi_achieved.d2d14e82.jpg",
    w: 6e3,
    h: 4e3
  }
};
const css = {
  code: '.flex-list.svelte-1co2f7o{display:flex;flex-wrap:wrap;gap:30px;justify-content:space-around;align-items:center;list-style-image:url("/svg/send.svg")}',
  map: null
};
const Page = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let stages = [
    [
      {
        label: "Private Pilot",
        icon: BookOpenPageVariant
      },
      {
        label: "Instrument Certificate",
        icon: CastEducation
      },
      {
        label: "Commercial Single Engine",
        icon: BookOpenPageVariant
      },
      {
        label: "Commercial Multi Engine",
        icon: Turbine
      }
    ]
  ];
  $$result.css.add(css);
  return `${$$result.head += `<!-- HEAD_svelte-13vmuvb_START -->${$$result.title = `<title>International Students | First Landings Aviation</title>`, ""}<meta name="description" content="First Landings Aviation international student pilot training"><!-- HEAD_svelte-13vmuvb_END -->`, ""} ${validate_component(Hero, "Hero").$$render(
    $$result,
    {
      alt: "International flight school student achieved first solo",
      src: hero_src
    },
    {},
    {
      main: () => {
        return `<div slot="main" data-svelte-h="svelte-qztrz7">International flight students coming to the US will be immersed to a completely new culture,
		new foods, people of many diverse backgrounds, and possibly driving on the “wrong” side of
		the road that you are used to! <br><br>Students at First Landings will also receive a
		comprehensive flight education focused on training them to become professional Airline
		Transport Pilots. <br><br>It makes no difference where you come from – be it North or
		South America, Europe, Asia, Africa, Pan Pacific, the only requirement is your desire to
		become a professional airline pilot.</div>`;
      },
      titleTwo: () => {
        return `<span slot="titleTwo"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-aoso4q">Students</span>`;
      },
      titleOne: () => {
        return `<span slot="titleOne"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-xx7alc">International</span>`;
      }
    }
  )} ${validate_component(Wrapper, "Wrapper").$$render($$result, {}, {}, {
    default: () => {
      return `${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-zl4a3p">Many aspiring pilots want to learn to fly and obtain a commercial pilots license in the
			United States due to the low costs and world recognition of the US FAA license.
			<br> <br>
			The state of Florida is one of the best places in the US to learn to fly, as it is at sea
			level, has very mild winter weather, and students can train nearly every day all year.</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1g337it">Florida is one of the best locations for training in the US</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-13nqorp">There are many flight schools in Florida that students can choose to learn to fly –
			ranging in size from schools with 5 airplanes to schools with 40 plus airplanes.
			<br> <br>
			So, as a prospective student, what do we at First Landings Aviation, offer you that sets
			us apart?
			<br> <br> <ol><li><b>Longevity in Business</b> <br>
					We have been providing professional flight training since 2009.</li> <br> <li><b>Location</b> <br>
					We are located near Orlando in Central Florida at Apopka (X04), at an uncontrolled
					airfield. Other flight schools are located in large Class C or D airports, which
					may require 20 minutes-plus to taxi to an active runway before taking off – and then
					an additional 5 to 10 minutes of flight to travel to the ‘practice area’. Our typical
					taxi time is less than 3 minutes, and our practice area is 1 minute from the airport.
					<br> <br>
					Why is important? In a 2 hour lesson, we spend nearly all the time flying, rather
					than 20% to 25% on the ground – this translates to approximately 50 to 60 hours of
					additional flight time, which gains the student more flight experience.</li> <br> <li><b>Part 141 international students only need 190 hours</b> <br>
					International students can obtain their FAA commercial Single Engine Land in 190
					hours, as compared to the typical 250 hours.</li> <br> <li><b>Modern Fleet of Aircraft</b> <br>
					First Landings has new Piper PA-28-181 Pilots 100i’s, Technically Advanced Aircraft
					(TAA), with Garmin G3X digital touch-screens and integrated digital avionics and
					autopilot, and the Tecnam P2006t multi-engine with duel digital G950’s and autopilots.
					We also have several Cessna 172’s and Tecnam P92’s.</li> <br> <li><b>Experienced Chief Pilot and Check Pilots</b> <br>
					Our Chief Pilot has over 33,000 flight hours, and over 12,000 dual instruction, and
					all our Check Pilots have over 800 hours minimum to qualify.</li> <br> <li><b>Standardized Training with our Certified Flight Instructors</b> <br>
					All new instructors are required to undergo internal training to meet our company
					standards, which when coupled with our structured training and stage checks, results
					in the same standards and level of training from all our instructors.</li> <br> <li><b>Personalized Training Experience</b> <br>
					Our approach is to develop custom, tailored training schedules for each student.
					Everybody learns in a different way, and rather than a regimented linear training
					schedule that requires the student to meet all of the standards or risk failing,
					we strive to understand what the underlying issues are, and work with students to
					develop strategies to help them overcome their various training obstacles.</li> <br> <li><b>Accelerated Flight Training Program</b> <br>
					For the serious students who want to achieve their single and multi-engine Commercial
					certificate, our accelerated program can graduate students with no flight experience
					in as little 4 months.</li> <br> <li><b>Standard Flight Training Program</b> <br>
					Our standard single and multi-engine Commercial program typically graduates students
					in 6 to 8 months.</li> <br> <li><b>Cost Effective Programs</b> <br>
					All our programs include the equipment, exams, aircraft rental and instructor costs,
					and are competitively priced.</li></ol></div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-15d0ghq">Why First Landings</span>`;
        }
      })} ${validate_component(Roadmap, "Roadmap").$$render($$result, { stages }, {}, {})} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main" data-svelte-h="svelte-kbaxxo">We offer the following Flight Training programs:
			<br> <br> <div class="flex-list svelte-1co2f7o"><ul><li>Private Pilot Ground</li> <li>Private Pilot Certificate</li> <li>Instrument Pilot Ground</li> <li>Instrument Pilot Certificate</li></ul> <ul><li>Commercial Single-Engine Land</li> <li>Commercial Multi-Engine Land Add-On</li></ul> <ul><li>Certified Flight Instructor (CFI)</li> <li>Instrument Flight Instructor (CFI-I)</li> <li>Multi-Engine Flight Instructor (MEI)</li></ul></div></div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-ewtseq">Offered Flight Training Programs</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main">If you already have a Private Pilot, Instrument Rating or FAA Commercial license, you
			can recertify yourself in as little as 3 hours. Contact First Landings Aviation for
			additional details.
			<br> <br> ${validate_component(Button, "Button").$$render($$result, { color: "blue", href: "/contact-us" }, {}, {
            default: () => {
              return `Contact Us Now`;
            }
          })}</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-c8rkg4">Re-Current / Bi-Annual Recertification</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main">If you already have an existing foreign Private Pilot, Instrument or Commercial license,
			you can contact First Landings Aviation on how we can help you convert your license and
			either obtain a certificate of authenticity (FAA equivalent license), or a full FAA
			license.
			<br> <br> ${validate_component(Button, "Button").$$render($$result, { color: "blue", href: "/contact-us" }, {}, {
            default: () => {
              return `Contact Us Now`;
            }
          })}</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1asqtdg">Foreign License Conversions</span>`;
        }
      })} ${validate_component(ContentCard, "ContentCard").$$render($$result, {}, {}, {
        main: () => {
          return `<div slot="main"><ol><li>Complete our <a href="/FLAP%20-%20OFA%20SEVIS%20Application%20Form.docx"${add_styles({ "color": `#15181c` })} data-svelte-h="svelte-c1uu4">Enrollment Application</a> and Checklist</li> <br> <li>E-mail your passport and government issued photo identification documents to <a href="mailto:info@firstlandings.com"${add_styles({ "color": `#15181c` })} data-svelte-h="svelte-rucoa2">info@firstlandings.com</a></li> <br> <li data-svelte-h="svelte-8akop8">Demonstrate that you have sufficient funds for your specified course (bank
					statement or equivalent)</li> <br> <li data-svelte-h="svelte-1e3chl2">First Landings will create your school account, allowing you to pay the
					enrollment fees, and then courier your student M1 Visa to your home address</li> <br> <li>Pay the <a href="https://www.ice.gov/sevis/i901" target="_blank"${add_styles({ "color": `#15181c` })} data-svelte-h="svelte-1f6g3et">SEVIS I-901 Fee</a></li> <br> <li>Complete the <a href="https://ceac.state.gov/genniv/" target="_blank"${add_styles({ "color": `#15181c` })} data-svelte-h="svelte-v782kf">online visa application form DS-160</a></li> <br> <li data-svelte-h="svelte-bgas7s">Schedule your Interview Appointment with the US Embassy or Consulate</li> <br> <li data-svelte-h="svelte-1iq91yx">Make sure to bring the required interview documents (can differ depending on
					your country of origin)</li> <br> <li data-svelte-h="svelte-1n0jvgl">Schedule and attend your US Embassy or Consulate interview</li> <br> <li data-svelte-h="svelte-1asoayg">Provide your passport to the appropriate US Embassy or Consulate to obtain your
					M1 Visa</li> <br> <li>Complete your
					<a href="https://www.fts.tsa.dhs.gov/home" target="_blank"${add_styles({ "color": `#15181c` })} data-svelte-h="svelte-lv07hc">TSA FTSP application</a>, using course PPL, or INST, or COMM SEL, with Piper PA-28-181 Pilot, or COMM
					MEL with Tecnam P2006t
					<br> <b data-svelte-h="svelte-15x7w7m">Note:</b> You will need to provide scanned copies of your various documents, and
					fingerprinting can be done in the US after your arrival</li> <br> <li data-svelte-h="svelte-cx0hag">Schedule your expected arrival date with First Landings and confirm with us once
					you are in the US</li></ol> <br> ${validate_component(Button, "Button").$$render(
            $$result,
            {
              href: "https://www.flyofa.com/",
              target: "_blank"
            },
            {},
            {
              default: () => {
                return `Enroll Now`;
              }
            }
          )}</div>`;
        },
        title: () => {
          return `<span slot="title"${add_styles({ "font-family": `inherit` })} data-svelte-h="svelte-1v5fdma">12 Easy Steps to Get Started</span>`;
        }
      })} ${validate_component(Image, "Image").$$render(
        $$result,
        {
          alt: "Multi student checkride pass",
          src: image_src
        },
        {},
        {}
      )}`;
    }
  })}`;
});

export { Page as default };
//# sourceMappingURL=_page.svelte-2ed8f736.js.map
