import { c as create_ssr_component, v as validate_component, d as add_styles, b as add_attribute, f as each, e as escape } from './ssr-73f02b7a.js';
import { I as Input } from './Input-aeb2b456.js';
import { B as Button } from './Button-b4fad8e7.js';
import { C as ContentCard } from './ContentCard-a01c572e.js';

const Email = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M20,8L12,13L4,8V6L12,11L20,6M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const HumanGreetingVariant = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { size = "1em" } = $$props;
  let { width = size } = $$props;
  let { height = size } = $$props;
  let { color = "currentColor" } = $$props;
  let { viewBox = "0 0 24 24" } = $$props;
  let { ariaLabel = void 0 } = $$props;
  let { ariaHidden = void 0 } = $$props;
  let { title = void 0 } = $$props;
  let { desc = void 0 } = $$props;
  let { class: className = void 0 } = $$props;
  if ($$props.size === void 0 && $$bindings.size && size !== void 0)
    $$bindings.size(size);
  if ($$props.width === void 0 && $$bindings.width && width !== void 0)
    $$bindings.width(width);
  if ($$props.height === void 0 && $$bindings.height && height !== void 0)
    $$bindings.height(height);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.viewBox === void 0 && $$bindings.viewBox && viewBox !== void 0)
    $$bindings.viewBox(viewBox);
  if ($$props.ariaLabel === void 0 && $$bindings.ariaLabel && ariaLabel !== void 0)
    $$bindings.ariaLabel(ariaLabel);
  if ($$props.ariaHidden === void 0 && $$bindings.ariaHidden && ariaHidden !== void 0)
    $$bindings.ariaHidden(ariaHidden);
  if ($$props.title === void 0 && $$bindings.title && title !== void 0)
    $$bindings.title(title);
  if ($$props.desc === void 0 && $$bindings.desc && desc !== void 0)
    $$bindings.desc(desc);
  if ($$props.class === void 0 && $$bindings.class && className !== void 0)
    $$bindings.class(className);
  return `<svg${add_attribute("viewBox", viewBox, 0)}${add_attribute("width", width, 0)}${add_attribute("height", height, 0)}${add_attribute("class", className, 0)}${add_attribute("aria-label", ariaLabel, 0)}${add_attribute("aria-hidden", ariaHidden, 0)}>${desc ? `<desc>${escape(desc)}</desc>` : ``}${title ? `<title>${escape(title)}</title>` : ``}<path d="M1.5,4V5.5C1.5,9.65 3.71,13.28 7,15.3V20H22V18C22,15.34 16.67,14 14,14C14,14 13.83,14 13.75,14C9,14 5,10 5,5.5V4M14,4A4,4 0 0,0 10,8A4,4 0 0,0 14,12A4,4 0 0,0 18,8A4,4 0 0,0 14,4Z"${add_attribute("fill", color, 0)}></path></svg>`;
});
const css$2 = {
  code: "select.svelte-1h7tns2{appearance:none;border:none;outline:none;background:#fff;border-radius:4rem;flex:1;width:100%;padding:1.5rem 3rem;font-size:1.6rem}",
  map: null
};
const CountryPicker = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { country } = $$props;
  const countries = [
    { name: "Afghanistan", emoji: "🇦🇫" },
    { name: "Albania", emoji: "🇦🇱" },
    { name: "Algeria", emoji: "🇩🇿" },
    { name: "Andorra", emoji: "🇦🇩" },
    { name: "Angola", emoji: "🇦🇴" },
    {
      name: "Antigua and Barbuda",
      emoji: "🇦🇬"
    },
    { name: "Argentina", emoji: "🇦🇷" },
    { name: "Armenia", emoji: "🇦🇲" },
    { name: "Australia", emoji: "🇦🇺" },
    { name: "Austria", emoji: "🇦🇹" },
    { name: "Azerbaijan", emoji: "🇦🇿" },
    { name: "Bahamas", emoji: "🇧🇸" },
    { name: "Bahrain", emoji: "🇧🇭" },
    { name: "Bangladesh", emoji: "🇧🇩" },
    { name: "Barbados", emoji: "🇧🇧" },
    { name: "Belarus", emoji: "🇧🇾" },
    { name: "Belgium", emoji: "🇧🇪" },
    { name: "Belize", emoji: "🇧🇿" },
    { name: "Benin", emoji: "🇧🇯" },
    { name: "Bhutan", emoji: "🇧🇹" },
    { name: "Bolivia", emoji: "🇧🇴" },
    {
      name: "Bosnia and Herzegovina",
      emoji: "🇧🇦"
    },
    { name: "Botswana", emoji: "🇧🇼" },
    { name: "Brazil", emoji: "🇧🇷" },
    { name: "Brunei", emoji: "🇧🇳" },
    { name: "Bulgaria", emoji: "🇧🇬" },
    { name: "Burkina Faso", emoji: "🇧🇫" },
    { name: "Burundi", emoji: "🇧🇮" },
    { name: "Cabo Verde", emoji: "🇨🇻" },
    { name: "Cambodia", emoji: "🇰🇭" },
    { name: "Cameroon", emoji: "🇨🇲" },
    { name: "Canada", emoji: "🇨🇦" },
    {
      name: "Central African Republic",
      emoji: "🇨🇫"
    },
    { name: "Chad", emoji: "🇹🇩" },
    { name: "Chile", emoji: "🇨🇱" },
    { name: "China", emoji: "🇨🇳" },
    { name: "Colombia", emoji: "🇨🇴" },
    { name: "Comoros", emoji: "🇰🇲" },
    { name: "Congo", emoji: "🇨🇬" },
    { name: "Costa Rica", emoji: "🇨🇷" },
    { name: "Croatia", emoji: "🇭🇷" },
    { name: "Cuba", emoji: "🇨🇺" },
    { name: "Cyprus", emoji: "🇨🇾" },
    { name: "Czechia", emoji: "🇨🇿" },
    {
      name: "Democratic Republic of the Congo",
      emoji: "🇨🇩"
    },
    { name: "Denmark", emoji: "🇩🇰" },
    { name: "Djibouti", emoji: "🇩🇯" },
    { name: "Dominica", emoji: "🇩🇲" },
    {
      name: "Dominican Republic",
      emoji: "🇩🇴"
    },
    { name: "Ecuador", emoji: "🇪🇨" },
    { name: "Egypt", emoji: "🇪🇬" },
    { name: "El Salvador", emoji: "🇸🇻" },
    { name: "Equatorial Guinea", emoji: "🇬🇶" },
    { name: "Eritrea", emoji: "🇪🇷" },
    { name: "Estonia", emoji: "🇪🇪" },
    { name: "Eswatini", emoji: "🇸🇿" },
    { name: "Ethiopia", emoji: "🇪🇹" },
    { name: "Fiji", emoji: "🇫🇯" },
    { name: "Finland", emoji: "🇫🇮" },
    { name: "France", emoji: "🇫🇷" },
    { name: "Gabon", emoji: "🇬🇦" },
    { name: "Gambia", emoji: "🇬🇲" },
    { name: "Georgia", emoji: "🇬🇪" },
    { name: "Germany", emoji: "🇩🇪" },
    { name: "Ghana", emoji: "🇬🇭" },
    { name: "Greece", emoji: "🇬🇷" },
    { name: "Grenada", emoji: "🇬🇩" },
    { name: "Guatemala", emoji: "🇬🇹" },
    { name: "Guinea", emoji: "🇬🇳" },
    { name: "Guinea-Bissau", emoji: "🇬🇼" },
    { name: "Guyana", emoji: "🇬🇾" },
    { name: "Haiti", emoji: "🇭🇹" },
    { name: "Holy See", emoji: "🇻🇦" },
    { name: "Honduras", emoji: "🇭🇳" },
    { name: "Hungary", emoji: "🇭🇺" },
    { name: "Iceland", emoji: "🇮🇸" },
    { name: "India", emoji: "🇮🇳" },
    { name: "Indonesia", emoji: "🇮🇩" },
    { name: "Iran", emoji: "🇮🇷" },
    { name: "Iraq", emoji: "🇮🇶" },
    { name: "Ireland", emoji: "🇮🇪" },
    { name: "Israel", emoji: "🇮🇱" },
    { name: "Italy", emoji: "🇮🇹" },
    { name: "Jamaica", emoji: "🇯🇲" },
    { name: "Japan", emoji: "🇯🇵" },
    { name: "Jordan", emoji: "🇯🇴" },
    { name: "Kazakhstan", emoji: "🇰🇿" },
    { name: "Kenya", emoji: "🇰🇪" },
    { name: "Kiribati", emoji: "🇰🇮" },
    { name: "Kuwait", emoji: "🇰🇼" },
    { name: "Kyrgyzstan", emoji: "🇰🇬" },
    { name: "Laos", emoji: "🇱🇦" },
    { name: "Latvia", emoji: "🇱🇻" },
    { name: "Lebanon", emoji: "🇱🇧" },
    { name: "Lesotho", emoji: "🇱🇸" },
    { name: "Liberia", emoji: "🇱🇷" },
    { name: "Libya", emoji: "🇱🇾" },
    { name: "Liechtenstein", emoji: "🇱🇮" },
    { name: "Lithuania", emoji: "🇱🇹" },
    { name: "Luxembourg", emoji: "🇱🇺" },
    { name: "Madagascar", emoji: "🇲🇬" },
    { name: "Malawi", emoji: "🇲🇼" },
    { name: "Malaysia", emoji: "🇲🇾" },
    { name: "Maldives", emoji: "🇲🇻" },
    { name: "Mali", emoji: "🇲🇱" },
    { name: "Malta", emoji: "🇲🇹" },
    { name: "Marshall Islands", emoji: "🇲🇭" },
    { name: "Mauritania", emoji: "🇲🇷" },
    { name: "Mauritius", emoji: "🇲🇺" },
    { name: "Mexico", emoji: "🇲🇽" },
    { name: "Micronesia", emoji: "🇫🇲" },
    { name: "Moldova", emoji: "🇲🇩" },
    { name: "Monaco", emoji: "🇲🇨" },
    { name: "Mongolia", emoji: "🇲🇳" },
    { name: "Montenegro", emoji: "🇲🇪" },
    { name: "Morocco", emoji: "🇲🇦" },
    { name: "Mozambique", emoji: "🇲🇿" },
    { name: "Myanmar", emoji: "🇲🇲" },
    { name: "Namibia", emoji: "🇳🇦" },
    { name: "Nauru", emoji: "🇳🇷" },
    { name: "Nepal", emoji: "🇳🇵" },
    { name: "Netherlands", emoji: "🇳🇱" },
    { name: "New Zealand", emoji: "🇳🇿" },
    { name: "Nicaragua", emoji: "🇳🇮" },
    { name: "Niger", emoji: "🇳🇪" },
    { name: "Nigeria", emoji: "🇳🇬" },
    { name: "North Korea", emoji: "🇰🇵" },
    { name: "North Macedonia", emoji: "🇲🇰" },
    { name: "Norway", emoji: "🇳🇴" },
    { name: "Oman", emoji: "🇴🇲" },
    { name: "Pakistan", emoji: "🇵🇰" },
    { name: "Palau", emoji: "🇵🇼" },
    { name: "Palestine", emoji: "🇵🇸" },
    { name: "Panama", emoji: "🇵🇦" },
    { name: "Papua New Guinea", emoji: "🇵🇬" },
    { name: "Paraguay", emoji: "🇵🇾" },
    { name: "Peru", emoji: "🇵🇪" },
    { name: "Philippines", emoji: "🇵🇭" },
    { name: "Poland", emoji: "🇵🇱" },
    { name: "Portugal", emoji: "🇵🇹" },
    { name: "Qatar", emoji: "🇶🇦" },
    { name: "Romania", emoji: "🇷🇴" },
    { name: "Russia", emoji: "🇷🇺" },
    { name: "Rwanda", emoji: "🇷🇼" },
    {
      name: "Saint Kitts and Nevis",
      emoji: "🇰🇳"
    },
    { name: "Saint Lucia", emoji: "🇱🇨" },
    {
      name: "Saint Vincent and the Grenadines",
      emoji: "🇻🇨"
    },
    { name: "Samoa", emoji: "🇼🇸" },
    { name: "San Marino", emoji: "🇸🇲" },
    {
      name: "Sao Tome and Principe",
      emoji: "🇸🇹"
    },
    { name: "Saudi Arabia", emoji: "🇸🇦" },
    { name: "Senegal", emoji: "🇸🇳" },
    { name: "Serbia", emoji: "🇷🇸" },
    { name: "Seychelles", emoji: "🇸🇨" },
    { name: "Sierra Leone", emoji: "🇸🇱" },
    { name: "Singapore", emoji: "🇸🇬" },
    { name: "Slovakia", emoji: "🇸🇰" },
    { name: "Slovenia", emoji: "🇸🇮" },
    { name: "Solomon Islands", emoji: "🇸🇧" },
    { name: "Somalia", emoji: "🇸🇴" },
    { name: "South Africa", emoji: "🇿🇦" },
    { name: "South Korea", emoji: "🇰🇷" },
    { name: "South Sudan", emoji: "🇸🇸" },
    { name: "Spain", emoji: "🇪🇸" },
    { name: "Sri Lanka", emoji: "🇱🇰" },
    { name: "Sudan", emoji: "🇸🇩" },
    { name: "Suriname", emoji: "🇸🇷" },
    { name: "Sweden", emoji: "🇸🇪" },
    { name: "Switzerland", emoji: "🇨🇭" },
    { name: "Syria", emoji: "🇸🇾" },
    { name: "Taiwan", emoji: "🇹🇼" },
    { name: "Tajikistan", emoji: "🇹🇯" },
    { name: "Tanzania", emoji: "🇹🇿" },
    { name: "Thailand", emoji: "🇹🇭" },
    { name: "Timor-Leste", emoji: "🇹🇱" },
    { name: "Togo", emoji: "🇹🇬" },
    { name: "Tonga", emoji: "🇹🇴" },
    {
      name: "Trinidad and Tobago",
      emoji: "🇹🇹"
    },
    { name: "Tunisia", emoji: "🇹🇳" },
    { name: "Turkey", emoji: "🇹🇷" },
    { name: "Turkmenistan", emoji: "🇹🇲" },
    { name: "Tuvalu", emoji: "🇹🇻" },
    { name: "Uganda", emoji: "🇺🇬" },
    { name: "Ukraine", emoji: "🇺🇦" },
    {
      name: "United Arab Emirates",
      emoji: "🇦🇪"
    },
    { name: "United Kingdom", emoji: "🇬🇧" },
    {
      name: "United States of America",
      emoji: "🇺🇸"
    },
    { name: "Uruguay", emoji: "🇺🇾" },
    { name: "Uzbekistan", emoji: "🇺🇿" },
    { name: "Vanuatu", emoji: "🇻🇺" },
    { name: "Venezuela", emoji: "🇻🇪" },
    { name: "Vietnam", emoji: "🇻🇳" },
    { name: "Yemen", emoji: "🇾🇪" },
    { name: "Zambia", emoji: "🇿🇲" },
    { name: "Zimbabwe", emoji: "🇿🇼" }
  ];
  country = "United States of America";
  if ($$props.country === void 0 && $$bindings.country && country !== void 0)
    $$bindings.country(country);
  $$result.css.add(css$2);
  return `<select required class="svelte-1h7tns2"${add_styles({ "appearance": `none` })}>${each(countries, (country2) => {
    return `<option${add_attribute("value", country2.name, 0)}>${escape(country2.emoji)} ${escape(country2.name)}</option>`;
  })}</select>`;
});
const css$1 = {
  code: ".wrapper.svelte-141dhbt{display:flex;gap:6rem;padding:7rem 5rem;border-radius:4rem;background-color:#f36d21;position:relative;overflow:hidden}@media(max-width: 1200px){.wrapper.svelte-141dhbt{flex-direction:column}}.title.svelte-141dhbt{font-size:4.4rem;font-family:'REM Variable', Inter, sans-serif}.text.svelte-141dhbt{flex:1;display:flex;flex-direction:column;z-index:1;gap:19rem}.p.svelte-141dhbt{font-size:2rem;font-style:normal;font-weight:400;line-height:normal;margin:0}.inputs.svelte-141dhbt{display:flex;flex-direction:column;flex:1;gap:2.5rem;z-index:1}.postal.svelte-141dhbt{position:absolute;left:-30px;top:-40px}.postal-plane.svelte-141dhbt{position:absolute;bottom:0;left:-50px;opacity:1;color:#fff;user-select:none;z-index:0}button.svelte-141dhbt{background:none;color:inherit;border:none;padding:0;font:inherit;cursor:pointer;outline:inherit}",
  map: null
};
const ContactSubmission = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { showModal } = $$props;
  let { financing = false } = $$props;
  let { form = null } = $$props;
  let country;
  let email_icon = Email;
  let HumanGreeting = HumanGreetingVariant;
  if ($$props.showModal === void 0 && $$bindings.showModal && showModal !== void 0)
    $$bindings.showModal(showModal);
  if ($$props.financing === void 0 && $$bindings.financing && financing !== void 0)
    $$bindings.financing(financing);
  if ($$props.form === void 0 && $$bindings.form && form !== void 0)
    $$bindings.form(form);
  $$result.css.add(css$1);
  let $$settled;
  let $$rendered;
  let previous_head = $$result.head;
  do {
    $$settled = true;
    $$result.head = previous_head;
    $$rendered = `${$$result.head += `<!-- HEAD_svelte-16u4sd4_START --><!-- HEAD_svelte-16u4sd4_END -->`, ""} <div class="wrapper svelte-141dhbt"><div class="text svelte-141dhbt"><h2 class="title svelte-141dhbt">${financing ? `Apply for financing now!` : `... Or You can Contact Us Now!`}</h2> <div><p class="p svelte-141dhbt">${financing ? `Send us a message to enquire about your eligibility for financing` : `We can’t wait to have you on-board`}</p> <br> <p class="p svelte-141dhbt" data-svelte-h="svelte-nqzpwc">Feel free to ask us any questions</p></div></div> <form class="inputs svelte-141dhbt" action="?/submit" method="POST">${validate_component(Input, "Input").$$render(
      $$result,
      {
        name: "name",
        invalid: form?.errors?.name ?? "",
        left_icon: HumanGreeting,
        placeholder: "Name",
        spellcheck: false,
        type: "text",
        value: form?.data?.name ?? ""
      },
      {},
      {}
    )} ${validate_component(Input, "Input").$$render(
      $$result,
      {
        name: "email",
        invalid: form?.errors?.email ?? "",
        left_icon: email_icon,
        placeholder: "Email",
        spellcheck: false,
        type: "text",
        value: form?.data?.email ?? ""
      },
      {},
      {}
    )} ${validate_component(CountryPicker, "CountryPicker").$$render(
      $$result,
      { country },
      {
        country: ($$value) => {
          country = $$value;
          $$settled = false;
        }
      },
      {}
    )} <input name="country" type="text"${add_styles({ "display": `none` })}${add_attribute("value", country, 0)}> ${validate_component(Input, "Input").$$render(
      $$result,
      {
        name: "message",
        invalid: form?.errors?.message ?? "",
        placeholder: "Message",
        small: false,
        value: form?.data?.message ?? ""
      },
      {},
      {}
    )} <button class="svelte-141dhbt">${validate_component(Button, "Button").$$render(
      $$result,
      {
        centered: true,
        color: "blue",
        size: "large"
      },
      {},
      {
        default: () => {
          return `${`Send`}`;
        }
      }
    )}</button></form> <div class="postal svelte-141dhbt" data-svelte-h="svelte-e08wlf"><img alt="postage" src="/postal.png"></div> <div class="postal-plane svelte-141dhbt" data-svelte-h="svelte-1surjef"><img alt="plane" src="/postal_plane.png" width="90%"></div> </div>`;
  } while (!$$settled);
  return $$rendered;
});
const css = {
  code: "button.svelte-1e2dsj3{background:none;color:inherit;border:none;padding:0;font:inherit;cursor:pointer;outline:inherit}dialog.svelte-1e2dsj3{width:50%;border:none;background:none}@media(max-width: 768px){dialog.svelte-1e2dsj3{width:90%}}dialog.svelte-1e2dsj3::backdrop{background:rgba(0,0,0,0.3)}dialog[open].svelte-1e2dsj3{animation:svelte-1e2dsj3-zoom 0.3s cubic-bezier(0.34, 1.56, 0.64, 1)}dialog[open].svelte-1e2dsj3::backdrop{animation:svelte-1e2dsj3-fade 0.2s ease-out}@-moz-keyframes svelte-1e2dsj3-zoom{from{transform:scale(0.95)}to{transform:scale(1)}}@-webkit-keyframes svelte-1e2dsj3-zoom{from{transform:scale(0.95)}to{transform:scale(1)}}@-o-keyframes svelte-1e2dsj3-zoom{from{transform:scale(0.95)}to{transform:scale(1)}}@keyframes svelte-1e2dsj3-zoom{from{transform:scale(0.95)}to{transform:scale(1)}}@-moz-keyframes svelte-1e2dsj3-fade{from{opacity:0}to{opacity:1}}@-webkit-keyframes svelte-1e2dsj3-fade{from{opacity:0}to{opacity:1}}@-o-keyframes svelte-1e2dsj3-fade{from{opacity:0}to{opacity:1}}@keyframes svelte-1e2dsj3-fade{from{opacity:0}to{opacity:1}}",
  map: null
};
const Modal = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { showModal } = $$props;
  let dialog;
  if ($$props.showModal === void 0 && $$bindings.showModal && showModal !== void 0)
    $$bindings.showModal(showModal);
  $$result.css.add(css);
  return ` <dialog class="svelte-1e2dsj3"${add_attribute("this", dialog, 0)}>${validate_component(ContentCard, "ContentCard").$$render($$result, { color: "blue" }, {}, {
    main: () => {
      return `<div slot="main">We have received your message and would like to thank you for
            writing to us. If your inquiry is urgent, please phone us on <a href="tel:+1-407-886-7612"${add_styles({
        "text-decoration": `none`,
        "color": `#2D3744`
      })} data-svelte-h="svelte-xix8by">+1 (407) 886-7612</a>
            to talk to one of our staff members.
            <br> <br>
            Otherwise, we will reply by email as soon as possible.
            <br> <br>
            Talk to you soon, First Landings Aviaiton
            <br> <br>  <button autofocus class="svelte-1e2dsj3">${validate_component(Button, "Button").$$render($$result, {}, {}, {
        default: () => {
          return `Close`;
        }
      })}</button></div>`;
    },
    title: () => {
      return `<div slot="title" data-svelte-h="svelte-1clcvg2">Thanks for being awesome!</div>`;
    }
  })} </dialog>`;
});

export { ContactSubmission as C, Modal as M };
//# sourceMappingURL=Modal-5f557ca5.js.map
