import { c as create_ssr_component, i as createEventDispatcher, v as validate_component, m as missing_component, b as add_attribute, e as escape, d as add_styles } from './ssr-73f02b7a.js';

const css = {
  code: ".clickable.svelte-29kigo{cursor:pointer;border-radius:5rem}.clickable.svelte-29kigo:hover{background:rgba(21,24,28,0.1)}.clickable.svelte-29kigo:active{background:rgba(21,24,28,0.2)}textarea.svelte-29kigo{appearance:none;border:none;outline:none;background:none;flex:1;height:33rem;width:100%;padding:1.5rem 3rem;font-size:1.6rem;resize:none}textarea.svelte-29kigo::placeholder{opacity:0.4}input.svelte-29kigo{appearance:none;border:none;outline:none;background:none;flex:1;width:100%;padding:1.5rem 3rem;padding-left:0;font-size:1.6rem}input.svelte-29kigo::placeholder{opacity:0.4}.input-pseudo-wrapper.svelte-29kigo{position:relative;overflow:visible;padding:0 0.6rem;border-radius:2.6rem;align-items:center;cursor:text;display:flex;background:#fff}.icon.svelte-29kigo{font-size:2rem;padding:0.6rem;margin-left:38px;color:#f36d21;display:inline-flex;align-items:center}.dark.svelte-29kigo{color:#fff}.error.svelte-29kigo{position:absolute;bottom:-35%;left:50%;transform:translateX(-50%);color:#f2f4fa}.invalid.svelte-29kigo{color:#e25454}",
  map: null
};
const Input = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  createEventDispatcher();
  let { placeholder = "" } = $$props;
  let { invalid } = $$props;
  let { spellcheck = true } = $$props;
  let { type = "" } = $$props;
  let { name = "" } = $$props;
  let { left_icon = null } = $$props;
  let { right_icon = null } = $$props;
  let { left_icon_handler = void 0 } = $$props;
  let { right_icon_handler = void 0 } = $$props;
  let { focus_on_mount = false } = $$props;
  let { value } = $$props;
  let { dark = false } = $$props;
  let { small = true } = $$props;
  let errorColor = false;
  let input_ref;
  if ($$props.placeholder === void 0 && $$bindings.placeholder && placeholder !== void 0)
    $$bindings.placeholder(placeholder);
  if ($$props.invalid === void 0 && $$bindings.invalid && invalid !== void 0)
    $$bindings.invalid(invalid);
  if ($$props.spellcheck === void 0 && $$bindings.spellcheck && spellcheck !== void 0)
    $$bindings.spellcheck(spellcheck);
  if ($$props.type === void 0 && $$bindings.type && type !== void 0)
    $$bindings.type(type);
  if ($$props.name === void 0 && $$bindings.name && name !== void 0)
    $$bindings.name(name);
  if ($$props.left_icon === void 0 && $$bindings.left_icon && left_icon !== void 0)
    $$bindings.left_icon(left_icon);
  if ($$props.right_icon === void 0 && $$bindings.right_icon && right_icon !== void 0)
    $$bindings.right_icon(right_icon);
  if ($$props.left_icon_handler === void 0 && $$bindings.left_icon_handler && left_icon_handler !== void 0)
    $$bindings.left_icon_handler(left_icon_handler);
  if ($$props.right_icon_handler === void 0 && $$bindings.right_icon_handler && right_icon_handler !== void 0)
    $$bindings.right_icon_handler(right_icon_handler);
  if ($$props.focus_on_mount === void 0 && $$bindings.focus_on_mount && focus_on_mount !== void 0)
    $$bindings.focus_on_mount(focus_on_mount);
  if ($$props.value === void 0 && $$bindings.value && value !== void 0)
    $$bindings.value(value);
  if ($$props.dark === void 0 && $$bindings.dark && dark !== void 0)
    $$bindings.dark(dark);
  if ($$props.small === void 0 && $$bindings.small && small !== void 0)
    $$bindings.small(small);
  $$result.css.add(css);
  {
    if (invalid) {
      errorColor = true;
    }
  }
  return `<div class="${["input-pseudo-wrapper svelte-29kigo", dark ? "dark" : ""].join(" ").trim()}">${left_icon ? `  <div class="${[
    "icon svelte-29kigo",
    (!!left_icon_handler ? "clickable" : "") + " " + (dark ? "dark" : "")
  ].join(" ").trim()}">${validate_component(left_icon || missing_component, "svelte:component").$$render($$result, {}, {}, {})}</div>` : ``} ${small ? `<input${add_attribute("name", name, 0)}${add_attribute("placeholder", placeholder, 0)}${add_attribute("spellcheck", spellcheck, 0)}${add_attribute("type", type, 0)}${add_attribute("value", value, 0)} class="${["svelte-29kigo", (dark ? "dark" : "") + " " + (errorColor ? "invalid" : "")].join(" ").trim()}"${add_attribute("this", input_ref, 0)}> ${invalid ? `<span class="error svelte-29kigo">${escape(invalid)}</span>` : ``}` : `<textarea${add_attribute("name", name, 0)}${add_attribute("placeholder", placeholder, 0)}${add_attribute("spellcheck", spellcheck, 0)} class="${["svelte-29kigo", (dark ? "dark" : "") + " " + (errorColor ? "invalid" : "")].join(" ").trim()}"${add_attribute("this", input_ref, 0)}>${escape(String(value), false)}</textarea> ${invalid ? `<span class="error svelte-29kigo"${add_styles({ "bottom": `-5%` })}>${escape(invalid)}</span>` : ``}`} ${right_icon ? `  <div class="${[
    "icon svelte-29kigo",
    (!!right_icon_handler ? "clickable" : "") + " " + (dark ? "dark" : "")
  ].join(" ").trim()}">${validate_component(right_icon || missing_component, "svelte:component").$$render($$result, {}, {}, {})}</div>` : ``}</div> ${slots.default ? slots.default({}) : ``}`;
});

export { Input as I };
//# sourceMappingURL=Input-aeb2b456.js.map
