import { c as create_ssr_component, b as add_attribute, f as each } from './ssr-73f02b7a.js';

const css = {
  code: ".image.svelte-1rlhb4t{height:100%;width:100%;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}",
  map: null
};
const Image = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { src } = $$props;
  let { alt } = $$props;
  if ($$props.src === void 0 && $$bindings.src && src !== void 0)
    $$bindings.src(src);
  if ($$props.alt === void 0 && $$bindings.alt && alt !== void 0)
    $$bindings.alt(alt);
  $$result.css.add(css);
  return `${typeof src === "string" ? `<img class="image svelte-1rlhb4t"${add_attribute("alt", alt, 0)}${add_attribute("src", src.img.src, 0)}${add_attribute("width", src.img.w, 0)}${add_attribute("height", src.img.h, 0)}>` : `<picture>${each(Object.entries(src.sources), ([format, srcset]) => {
    return `<source${add_attribute("srcset", srcset, 0)}${add_attribute("sizes", "90vw", 0)}${add_attribute("type", "image/" + format, 0)}>`;
  })} <img class="image svelte-1rlhb4t"${add_attribute("alt", alt, 0)}${add_attribute("src", src.img.src, 0)}${add_attribute("width", src.img.w, 0)}${add_attribute("height", src.img.h, 0)}></picture>`}`;
});

export { Image as I };
//# sourceMappingURL=Image-c986cba7.js.map
