import { c as create_ssr_component, b as add_attribute, e as escape, f as each } from './ssr-73f02b7a.js';

const css = {
  code: `.ContentCard.svelte-az1zw6{background-color:#fff;display:flex;flex-direction:column;gap:2rem;width:100%;height:min-content;padding:2rem 6rem;border-radius:4rem;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}@media screen and (min-width: 1536px){.ContentCard.svelte-az1zw6{flex-direction:row}}.ContentCard__main.svelte-az1zw6{width:100%;padding:2rem 0rem;display:flex;flex-direction:column;gap:2rem}.ContentCard__main--heading.svelte-az1zw6{font-size:3rem;font-weight:700;line-height:normal;margin:0;padding:0;color:#15181c;text-align:left;max-width:none;font-family:'REM Variable';text-decoration:none}.ContentCard__main--text.svelte-az1zw6{font-size:1.8rem;font-weight:400;line-height:normal;margin:0;padding:0;color:#15181c;text-align:left;max-width:none;font-family:"Inter Variable";text-decoration:none;max-width:70%}@media screen and (max-width: 1536px){.ContentCard__main--text.svelte-az1zw6{max-width:100%}}.ContentCard__secondary.svelte-az1zw6{align-self:center}.ContentCard__secondary--img.svelte-az1zw6{height:auto;max-height:40rem;border-radius:2rem;object-fit:cover;width:100%}@media screen and (min-width: 1536px){.ContentCard__secondary--img.svelte-az1zw6{width:38rem}}.orange.svelte-az1zw6{border:0.3rem solid #f36d21}.blue.svelte-az1zw6{border:0.3rem solid #0e76bc}.full.svelte-az1zw6{max-width:100%}.hidden.svelte-az1zw6{display:none}`,
  map: null
};
const ContentCard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { color = "orange" } = $$props;
  let { src = void 0 } = $$props;
  let { alt = void 0 } = $$props;
  let { id = void 0 } = $$props;
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.src === void 0 && $$bindings.src && src !== void 0)
    $$bindings.src(src);
  if ($$props.alt === void 0 && $$bindings.alt && alt !== void 0)
    $$bindings.alt(alt);
  if ($$props.id === void 0 && $$bindings.id && id !== void 0)
    $$bindings.id(id);
  $$result.css.add(css);
  return `<article${add_attribute("id", id, 0)} class="${"ContentCard " + escape(color, true) + " svelte-az1zw6"}"><section class="ContentCard__main svelte-az1zw6"><h2 class="ContentCard__main--heading svelte-az1zw6">${slots.title ? slots.title({}) : ``}</h2> <p class="${"ContentCard__main--text " + escape(src ? "" : "full", true) + " svelte-az1zw6"}">${slots.main ? slots.main({}) : ``}</p></section> <section class="${"ContentCard__secondary " + escape(src ? "" : "hidden", true) + " svelte-az1zw6"}">${src ? `${typeof src === "string" ? `<img class="ContentCard__secondary--img svelte-az1zw6"${add_attribute("alt", alt, 0)}${add_attribute("src", src.img.src, 0)}${add_attribute("width", src.img.w, 0)}${add_attribute("height", src.img.h, 0)}>` : `<picture>${each(Object.entries(src.sources), ([format, srcset]) => {
    return `<source${add_attribute("srcset", srcset, 0)} sizes="min(450px, 100%)"${add_attribute("type", "image/" + format, 0)}>`;
  })} <img class="ContentCard__secondary--img svelte-az1zw6"${add_attribute("alt", alt, 0)}${add_attribute("src", src.img.src, 0)}${add_attribute("width", src.img.w, 0)}${add_attribute("height", src.img.h, 0)}></picture>`}` : ``}</section> </article>`;
});

export { ContentCard as C };
//# sourceMappingURL=ContentCard-a01c572e.js.map
