import { c as create_ssr_component, e as escape, b as add_attribute } from './ssr-73f02b7a.js';

function formatDate(date, dateStyle = "medium", locales = "en") {
  const dateToFormat = new Date(date.replaceAll("-", "/"));
  const dateFormatter = new Intl.DateTimeFormat(locales, { dateStyle });
  return dateFormatter.format(dateToFormat);
}
const css = {
  code: `.card.svelte-18ok74i.svelte-18ok74i{background-color:#fff;display:flex;flex-direction:column;height:100%;max-width:50rem;margin:auto;border-radius:2rem;overflow:hidden;box-shadow:0 1.5rem 3rem rgba(0,0,0,0.1)}.card__main.svelte-18ok74i.svelte-18ok74i{width:100%;padding:2rem 2rem;display:flex;flex-direction:column;gap:2rem;margin-top:auto}.card__main--heading.svelte-18ok74i.svelte-18ok74i{font-size:2.2rem;font-weight:700;line-height:normal;margin:0;padding:0;color:#15181c;text-align:left;max-width:none;font-family:'REM Variable';text-decoration:none}.card__main--text.svelte-18ok74i.svelte-18ok74i{font-size:1.8rem;font-weight:400;line-height:normal;margin:0;padding:0;color:#15181c;text-align:left;max-width:none;font-family:"Inter Variable";text-decoration:none;max-width:70%}@media screen and (max-width: 1536px){.card__main--text.svelte-18ok74i.svelte-18ok74i{max-width:100%}}.card__secondary.svelte-18ok74i.svelte-18ok74i{align-self:center;min-width:100%}.card__secondary--img.svelte-18ok74i.svelte-18ok74i{height:auto;object-fit:cover;min-width:100%;max-height:25rem}.card.svelte-18ok74i.svelte-18ok74i:hover{box-shadow:0 1rem 2rem rgba(0,0,0,0.1);transform:translateY(-2px)}.card.svelte-18ok74i.svelte-18ok74i:active{box-shadow:0 0.5rem 1rem rgba(0,0,0,0.1);transform:translateY(0px)}.small.svelte-18ok74i.svelte-18ok74i{border-radius:1rem}.small.svelte-18ok74i .card__main.svelte-18ok74i{padding:1rem;gap:1rem}.small.svelte-18ok74i .card__main--heading.svelte-18ok74i{font-size:1.6rem}.small.svelte-18ok74i .card__main--text.svelte-18ok74i{font-size:1.2rem}.small.svelte-18ok74i .card__secondary--img.svelte-18ok74i{max-height:15rem}.orange.svelte-18ok74i.svelte-18ok74i{border:0.3rem solid #f36d21}.blue.svelte-18ok74i.svelte-18ok74i{border:0.3rem solid #0e76bc}.full.svelte-18ok74i.svelte-18ok74i{max-width:100%}.hidden.svelte-18ok74i.svelte-18ok74i{display:none}`,
  map: null
};
const BlogContentCard = create_ssr_component(($$result, $$props, $$bindings, slots) => {
  let { small = false } = $$props;
  let { color = "orange" } = $$props;
  let { src = void 0 } = $$props;
  let { alt = void 0 } = $$props;
  if ($$props.small === void 0 && $$bindings.small && small !== void 0)
    $$bindings.small(small);
  if ($$props.color === void 0 && $$bindings.color && color !== void 0)
    $$bindings.color(color);
  if ($$props.src === void 0 && $$bindings.src && src !== void 0)
    $$bindings.src(src);
  if ($$props.alt === void 0 && $$bindings.alt && alt !== void 0)
    $$bindings.alt(alt);
  $$result.css.add(css);
  return `<article class="${["card " + escape(color, true) + " svelte-18ok74i", small ? "small" : ""].join(" ").trim()}"><section class="${"card__secondary " + escape(src ? "" : "hidden", true) + " svelte-18ok74i"}">${src ? `<img class="card__secondary--img svelte-18ok74i"${add_attribute("alt", alt, 0)}${add_attribute("src", src, 0)}>` : ``}</section> <section class="card__main svelte-18ok74i"><h2 class="card__main--heading svelte-18ok74i">${slots.title ? slots.title({}) : ``}</h2> <p class="${"card__main--text " + escape(src ? "" : "full", true) + " svelte-18ok74i"}">${slots.main ? slots.main({}) : ``}</p></section> </article>`;
});

export { BlogContentCard as B, formatDate as f };
//# sourceMappingURL=BlogContentCard-0be201aa.js.map
