import { e as error } from './index-916a7dc8.js';
import { s as stylesheet_6 } from './6-9edbea45.js';
import { s as stylesheet_19 } from './19-d357e702.js';
import { s as stylesheet_9 } from './9-6e7cc6e6.js';

class PostArray {
  constructor(posts) {
    this.posts = posts;
  }
  appendSections(sections) {
    return this.posts.map((post) => ({
      ...post,
      sections: sections.filter((el) => el.post === post.id)
    }));
  }
  replaceTagIdsWithNames(tags) {
    const tagMap = {};
    tags.forEach((tag) => {
      tagMap[tag.id] = tag.name;
    });
    return this.posts.map((post) => ({
      ...post,
      tags: post.tags.map((tagId) => {
        const tag = tags.find((tag2) => tag2.id === tagId);
        return tag ? tag.name : null;
      })
    }));
  }
  createSearchTerms() {
    return this.posts.map((post) => ({
      ...post,
      searchTerms: `${post.title} ${post.description} ${post.content} ${post.sections?.map((section) => section.subtitle)} ${post.sections?.map((section) => section.content_1)} ${post.sections?.map((section) => section.content_2)} ${post.sections?.map((section) => section.image_alt)} ${post.tags.map((tag) => tag)}`
    }));
  }
  getPostById(id) {
    return this.posts.find((post) => post.id === id);
  }
  getPostsByTag(tag) {
    return this.posts.filter((post) => post.tags.includes(tag));
  }
  getPublishedPosts() {
    return this.posts.filter((post) => post.published);
  }
  getUnpublishedPosts() {
    return this.posts.filter((post) => !post.published);
  }
}
const load = async ({ fetch }) => {
  let res;
  try {
    res = await fetch(`https://admin.firstlandings.com/api/blog/posts`);
    const posts = new PostArray(await res.json());
    res = await fetch(`https://admin.firstlandings.com/api/blog/sections`);
    const sections = await res.json();
    posts.appendSections(sections);
    res = await fetch(`https://admin.firstlandings.com/api/blog/post-tags`);
    const tags = await res.json();
    posts.replaceTagIdsWithNames(tags);
    return { posts };
  } catch (e) {
    throw error(500, `${e}`);
  }
};

var _page_ts = /*#__PURE__*/Object.freeze({
  __proto__: null,
  load: load
});

// _app/immutable/assets/5.698818b7.css
var stylesheet_4 = ".heading.svelte-17gi7ty{color:#15181c;font-size:3rem}.flex.svelte-17gi7ty{display:flex;justify-content:space-between;align-items:center}.grid.svelte-17gi7ty{display:grid;grid-template-columns:repeat(auto-fit,minmax(35rem,1fr));gap:5rem}@media screen and (max-width:640px){.grid.svelte-17gi7ty{grid-template-columns:1fr}}.card.svelte-17gi7ty{text-decoration:none}\n";

const index = 5;
let component_cache;
const component = async () => component_cache ??= (await import('./_page.svelte-53406ae6.js')).default;
const universal_id = "src/routes/blog/+page.ts";
const imports = ["_app/immutable/nodes/5.02dc49c8.js","_app/immutable/chunks/BlogContentCard.3c3d172f.js","_app/immutable/chunks/control.f5b05b5f.js","_app/immutable/chunks/scheduler.5b890119.js","_app/immutable/chunks/index.1673eb25.js","_app/immutable/chunks/each.15f1f0ab.js","_app/immutable/chunks/index.852d6942.js","_app/immutable/chunks/Wrapper.a05beb49.js","_app/immutable/chunks/Input.407603bd.js"];
const stylesheets = ["_app/immutable/assets/5.698818b7.css","_app/immutable/assets/BlogContentCard.ad128bc8.css","_app/immutable/assets/Wrapper.54de1bd5.css","_app/immutable/assets/Input.8fc26899.css"];
const fonts = [];
const inline_styles = () => ({
	"_app/immutable/assets/5.698818b7.css": stylesheet_4,
	"_app/immutable/assets/BlogContentCard.ad128bc8.css": stylesheet_6,
	"_app/immutable/assets/Wrapper.54de1bd5.css": stylesheet_19,
	"_app/immutable/assets/Input.8fc26899.css": stylesheet_9
});

export { component, fonts, imports, index, inline_styles, stylesheets, _page_ts as universal, universal_id };
//# sourceMappingURL=5-34e7b4a2.js.map
